<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Create supplier_orders table
    $sql = "CREATE TABLE IF NOT EXISTS supplier_orders (
        id INT AUTO_INCREMENT PRIMARY KEY,
        supplier_id INT NOT NULL,
        order_date DATE NOT NULL,
        expected_delivery_date DATE NULL,
        notes TEXT NULL,
        status ENUM('pending', 'approved', 'completed', 'cancelled') DEFAULT 'pending',
        total_amount DECIMAL(10,2) DEFAULT 0.00,
        created_by INT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_supplier_id (supplier_id),
        INDEX idx_order_date (order_date),
        INDEX idx_status (status),
        INDEX idx_created_by (created_by),
        INDEX idx_created_at (created_at),
        FOREIGN KEY (supplier_id) REFERENCES suppliers(id) ON DELETE CASCADE,
        FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    $pdo->exec($sql);
    echo "✅ supplier_orders table created successfully!\n";

    // Create supplier_order_items table
    $sql = "CREATE TABLE IF NOT EXISTS supplier_order_items (
        id INT AUTO_INCREMENT PRIMARY KEY,
        order_id INT NOT NULL,
        product_id INT NOT NULL,
        quantity INT NOT NULL,
        unit_price DECIMAL(10,2) NULL,
        total_price DECIMAL(10,2) NULL,
        notes TEXT NULL,
        received_quantity INT DEFAULT 0,
        status ENUM('pending', 'partial', 'received', 'cancelled') DEFAULT 'pending',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_order_id (order_id),
        INDEX idx_product_id (product_id),
        INDEX idx_status (status),
        FOREIGN KEY (order_id) REFERENCES supplier_orders(id) ON DELETE CASCADE,
        FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    $pdo->exec($sql);
    echo "✅ supplier_order_items table created successfully!\n";

    // Check if the tables were created properly
    $stmt = $pdo->query("DESCRIBE supplier_orders");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "📋 supplier_orders columns: " . implode(', ', $columns) . "\n";

    $stmt = $pdo->query("DESCRIBE supplier_order_items");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "📋 supplier_order_items columns: " . implode(', ', $columns) . "\n";

} catch (PDOException $e) {
    echo "❌ Error creating supplier orders tables: " . $e->getMessage() . "\n";
    exit(1);
}

echo "🎉 Migration completed successfully!\n";
?> 